
"use strict";

var getLocation = function(href) {	
	var l = document.createElement("a");
	l.href = href;
	return l;
}; 
(function($){
	"use strict";
	// jShorten Method
	$.fn.extend({ 
		shorten: function(settings) {
			var defaults = {
			  url:null,
			  key:null,
			  internal: false
			};
			var s = $.extend(defaults, settings);
			var error=0;

			if(s.url===null){
			  console.log('Please set the url to the api of the url shortener script.');
				error=1;
			}
			if(s.key===null){
				console.log('Please set your API key.');
				error=1;              
			}
			if(error==0){  
				$(this).each(function(){
				  var e=$(this);
				  var l = getLocation(e.attr("href"));
				  if(l.hostname!=location.hostname){
					$.getJSON(s.url+"api?callback=?",
					  {
						api: s.key,
						url: e.attr("href")
					  },
					  function(r) {
					   if(r.error=='0'){
						  e.attr('href',r.short);
					   }else{
						  console.log(r.msg);
					   }      
					});               
				  }
				});
			}                          
		}
	});

	$(document).ready(function(){

	  $(document).on('click', '.PUS_for_advanced', function(e){
		e.preventDefault();
		$('.PUS_advanced').slideToggle();
	  });

	  // Shorten Ajax
	  $(document).on('submit',".PUS_main form.PUS_form",function(e) {
		e.preventDefault();
		let form = $(this);
		let main = form.parent('.PUS_main');
		let url = form.find(".PUS_input");
		

		if(!url.val()){
		  main.find('#pus_message').hide().html('Please enter a valid URL (including https:&#47;&#47;)').fadeIn('slow');
		  main.find('#pus_message').addClass("PUS_error");
		  return;
		}

		let text = form.find('button[type=submit]').text();

		jQuery.ajax({
		  url: form.attr('action'),
		  method: 'POST',
		  data: form.serialize(),
		  beforeSend: function() {
			form.find('button[type=submit]').html('<img src="'+form.data('loader')+'" id="pus_loader">');
		  }
		})
		.fail(function(){
		  $(".PUS_form").before('<div id="pus_message" class="PUS_message">An error occurred. Please try again later</div>')
		})
		.done(function(response){
		 form.find('#pus_message').remove();
		 form.find('input').removeClass('pus_error');
	
		  if(typeof response.html !== undefined){
			jQuery('body').append(response.html);
		  }
		  
		  form.find('button[type=submit]').text(text);
	
		  if(response.error){
			 form.prepend('<div id="pus_message" class="PUS_message">'+response.message+'</div>');            
			}else{          
			  form.prepend('<div id="pus_message" class="PUS_success">'+response.message+'</div>');   
			  form.find('input[name=url]').val(response.shorturl);  
			  form.find('input[name=url]').select();
			  form.find('input[name=custom]').val('');
			  form.find('input[name=password]').val('');
			}
		}); 
	  });
	});
})(jQuery);