<?php
/**
 * =======================================================================================
* (c) SAS tools
* ---------------------------------------------------------------------------------------
* This software is packaged with an exclusive framework as such distribution
* or modification of this framework is not allowed before prior consent from
* SAS tools. If you find that this framework is packaged in a software not distributed
* by SAS tools or authorized parties, you must not use this software and contact gempixel
* at https://www.sas.com.ru/wp/obratnaja-svjaz/ to inform them of this misuse.
* =======================================================================================
*
* @package SAS tools\URL-Shortener-WP
* @author SAS tools (https://www.sas.com.ru/)
* @link https://www.sas.com.ru/
 */

class PUS_Widget extends WP_Widget {
 	
	/**
	 * @var Configuration
	 **/
	public static $config = [];
	
	/**
	 * Register Widget
	 *
	 * @author SAS tools <https://www.sas.com.ru> 
	 * @version 3.0
	 */
	function __construct() {  
		
		$config = [
			'classname' => 'PUS_Widget', 
			'description' => __('Displays the frontend form for shortening URLs.'), 
			'panels_icon' => 'dashicons dashicons-links'
		];  

		parent::__construct('PUS_Widget', __('URL Shortener Widget', 'shortener-plugin'), $config);  
	}  
	/**
	 * Generate Widget Form 
	 * @since 3.0
	 **/		
	function form($instance) {
	
		$instance = wp_parse_args( (array) $instance, array( 'title' => '','theme'=> '') );

		$title = $instance['title'];    
		echo '<p><label for="'.$this->get_field_id('title').'">Title: <input class="widefat" id="'.$this->get_field_id('title').'" name="'.$this->get_field_name('title').'" type="text" value="'.esc_attr($title).'" /></label></p>';
		echo '</select></p>';
	}
	/**
	 * Update Settings
	 * @since 3.0
	 **/
	function update($new_instance, $old_instance){
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		return $instance;
	}

	/**
	 * In-Post/In-Page Forms
	 * @since 3.0
	 **/
	public static function post_form($atts,$content){
		$URI = self::$config["shortener_url"];	
		return '<div class="PUS_main">					
			<div class="PUS_message"></div>
			<form action="'.admin_url('admin-ajax.php' ).'" data-loader="'.plugins_url('assets/loader.svg', dirname(__FILE__) ).'" class="PUS_form">
				<div class="PUS_box">
					<input type="text" class="PUS_input" name="url" placeholder="'.esc_attr__('Enter a long link with http:// or https://').'">
					<button type="submit" class="PUS_button">
						'.esc_attr__('Shorten').'
					</button>
				</div>
				<a href="#" class="PUS_for_advanced">'.esc_attr__('Advanced').'</a>
				<div class="PUS_advanced">
					<div class="PU_custom_input_container">
						<label for="PUS_custom_input">'.esc_attr__("Custom Alias").'</label>
						<input type="text" class="PUS_custom_input" name="custom" placeholder="e.g. apple">				
					</div>
				</div>
				<input type="hidden" name="action" value="pus_shorten">
			</form>
		</div>';
	}
	/**
	 * In Template Widget
	 * @since 3.0
	 **/
  	function widget($args, $instance){

		extract($args, EXTR_SKIP);
	
		echo $before_widget;
		$title = empty($instance['title']) ? ' ' : apply_filters('widget_title', $instance['title']);	
	
		if (!empty($title))	echo $before_title . $title . $after_title;
		
		$URI = self::$config["shortener_url"];		
		include(PUSDIR."/template/form.php");

		echo $after_widget;
	}
}