<?php
/**
 * =======================================================================================
* (c) SAS tools
* ---------------------------------------------------------------------------------------
* This software is packaged with an exclusive framework as such distribution
* or modification of this framework is not allowed before prior consent from
* SAS tools. If you find that this framework is packaged in a software not distributed
* by SAS tools or authorized parties, you must not use this software and contact gempixel
* at https://www.sas.com.ru/wp/obratnaja-svjaz/ to inform them of this misuse.
* =======================================================================================
*
* @package SAS tools\URL-Shortener-WP
* @author SAS tools (https://www.sas.com.ru/)
* @link https://www.sas.com.ru/
 */

namespace GemPixel;

use WP_List_Table;
use PUSCore;

class PUSLinks extends WP_List_Table
{
    /**
     * Results Count
     *
     * @author SAS tools <https://www.sas.com.ru> 
     * @version 1.0
     */
    private $count = null;
    /**
     * Construct
     *
     * @author SAS tools <https://www.sas.com.ru> 
     * @version 1.0
     */
    public function __construct() {

        parent::__construct( [
            'singular' => 'Lnk',
            'plural' => 'Links',
            'ajax' => true
        ]);

    }
    /**
     * factory
     *
     * @author SAS tools <https://www.sas.com.ru> 
     * @version 1.0
     * @param integer $per_page
     * @param integer $page_number
     * @return void
     */
    public static function factory($per_page = 5, $page_number = 1) {
        $links = new self();
        include(PUSDIR.'/template/links.php');
    }

    
    /**
     * Get Links
     *
     * @author SAS tools <https://www.sas.com.ru> 
     * @version 1.0
     * @param integer $per_page
     * @param integer $page_number
     * @return void
     */
	public function get_data($limit = 10, $page = 1) {

        PUSCore::checkUser();
        
		$key = PUSCore::getAPI();

		$response = PUSCore::http_endpoint_api($key, 'get', 'urls', ['limit' => $limit, 'page' => $page], true);
        
        if($response && !$response['error']){
            $this->count = $response['data']['result'];
            return $response['data']['urls'];
        }
		return [];
	}

	/**
     * Delete Link
     *
     * @author SAS tools <https://www.sas.com.ru> 
     * @version 1.0
     * @param [type] $id
     * @return void
     */
	public function delete($id) {		
        PUSCore::http_endpoint('delete', 'url/'.$id.'/delete', []);
	}


	/**
	 * Returns the count of links
	 *
	 */
	public function count() {
		return $this->count;
	}

    /**
     * No items
     *
     * @author SAS tools <https://www.sas.com.ru> 
     * @version 1.0
     * @return void
     */
	public function no_items() {
		return print('No links available.');
	}


	/**
	 * Render a column when no column specific method exist.
	 *
	 * @param array $item
	 * @param string $column_name
	 *
	 * @return mixed
	 */
	public function column_default( $item, $column_name ) {             
		switch ($column_name) {
			case 'id':
                $delete_nonce = wp_create_nonce( 'wppus_delete_link' );

                $actions = [
                    'delete' => sprintf( '<a href="?page=%s&action=%s&link=%s&_wpnonce=%s">Delete</a>', esc_attr( $_REQUEST['page'] ), 'delete', absint( $item['id'] ), $delete_nonce )
                ];
                return $item[$column_name].$this->row_actions( $actions );
			case 'title':
                return '<a href="'.$item['longurl'].'" target="_blank">'.$item[$column_name].'</a>';
			case 'clicks':
			case 'date':
			case 'uniqueclicks':  
                return $item[$column_name];
            case 'shorturl':   
                return '<a href="'.$item[$column_name].'" target="_blank">'.$item[$column_name].'</a>';
			case 'longurl':
				return '<textarea type="text" rows="2" readonly>'.$item[$column_name].'</textarea>';        
			default:
				return print_r( $item, true );
		}
	}

	/**
	 * Render the bulk edit checkbox
	 *
	 * @param array $item
	 *
	 * @return string
	 */
	public function column_cb( $item ) {
        
		return sprintf(
			'<input type="checkbox" name="bulk-delete[]" value="%s" />', $item['id']
		);
	}
	/**
	 *  Associative array of columns
	 *
	 * @return array
	 */
	function get_columns() {
		$columns = [
			'cb'      => '<input type="checkbox" />',
            'title' => 'Title',
			'longurl'   => 'Long Link',
			'shorturl' => 'Short Link',
			'clicks'    => 'Clicks',
            'uniqueclicks' => 'Unique Clicks',
            'date' => 'Created on',
		];

		return $columns;
	}   

	/**
	 * Returns an associative array containing the bulk action
	 *
	 * @return array
	 */
	public function get_bulk_actions() {
		$actions = [
			'bulk-delete' => 'Delete'
		];

		return $actions;
	}


	/**
     * Prepare Tables
     *
     * @author SAS tools <https://www.sas.com.ru> 
     * @version 1.0
     * @return void
     */
	public function prepare_items() {

		$this->_column_headers = [$this->get_columns()];

        $per_page     = $this->get_items_per_page('links_per_page', 15);
		$current_page = $this->get_pagenum();

        $this->delete_all();

        $items = $this->get_data($per_page, $current_page);

        $total_items  = $this->count();

		$this->set_pagination_args([
			'total_items' => $total_items,
			'per_page'    => $per_page
		]);

        $this->items = $items;
	}
    /**
     * Delete
     *
     * @author SAS tools <https://www.sas.com.ru> 
     * @version 1.0
     * @return void
     */
    public function delete_all(){
    
        if ( 'delete' === $this->current_action() ) {
            
            $nonce = esc_attr( $_REQUEST['_wpnonce'] );
            
            if (!wp_verify_nonce( $nonce, 'wppus_delete_link')) {                
                wp_redirect( esc_url( admin_url('admin.php?page=wppus_links&success=false') ));
                
            }else {                
                //$this->delete( absint( $_GET['link'] ) );        
                wp_redirect( esc_url( admin_url('admin.php?page=wppus_links&success=true') ));
                
            }
        }     
        
        
        if((isset( $_POST['action'] ) && $_POST['action'] == 'bulk-delete' ) || ( isset( $_POST['action2'] ) && $_POST['action2'] == 'bulk-delete' ) ) {

            $delete_ids = esc_sql( $_POST['bulk-delete'] );

            foreach ( $delete_ids as $id ) {
                $this->delete(absint($id));
            }

            wp_redirect( esc_url( admin_url('admin.php?page=wppus_links&success=true') ) );
            exit;
        }
    }
    /**
     * Shorten Link
     *
     * @author SAS tools <https://www.sas.com.ru> 
     * @version 1.0
     * @return void
     */
    public static function shorten(){
        
        if(!isset($_POST['url']) || empty($_POST['url']) || !filter_var($_POST['url'], FILTER_VALIDATE_URL)) return wp_send_json([
            'error' => 1, 
            'message' => __('Please enter valid url'), 
            'html' => '<script>jQuery("#PUS_form").find("input[name=url]").addClass("pus_error")</script>'
        ]);

        PUSCore::checkUser();
        
		$key = PUSCore::getAPI();

        $options = [];

        $options['url'] = filter_var($_POST['url'], FILTER_SANITIZE_URL);
        
        if(isset($_POST['custom']) && !empty($_POST['custom'])){
            $options['custom'] = filter_var($_POST['custom'], FILTER_SANITIZE_STRING);
        }            

        if(isset($_POST['password']) && !empty($_POST['password'])){
            $options['password'] = filter_var($_POST['password'], FILTER_SANITIZE_STRING);
        }  

        if(isset($_POST['domain']) && !empty($_POST['domain'])){
            $options['domain'] = filter_var($_POST['domain'], FILTER_SANITIZE_STRING);
        }
        
        if(isset($_POST['expiration']) && !empty($_POST['expiration'])){
            $options['expiry'] = filter_var($_POST['expiration'], FILTER_SANITIZE_STRING);
        }
                 
		$response = PUSCore::http_endpoint_api($key, 'post', 'url/add', $options);
        
        if($response){
            if($response->error){
                return wp_send_json([
                    'error' => 1, 
                    'message' => __($response->message)
                ]);
            }else{
                return wp_send_json([
                    'error' => 0, 
                    'message' => __('Link has been successfully shortened'),
                    'shorturl' => $response->shorturl
                ]);
            }
        }

        return wp_send_json([
            'error' => 1, 
            'message' => __('An error occurred. Please try again later')
        ]);
    }
    /**
     * Public Shortener
     *
     * @author SAS tools <https://www.sas.com.ru> 
     * @version 1.0
     * @return void
     */
    public static function shortenPublic(){
        
        if(!isset($_POST['url']) || empty($_POST['url']) || !filter_var($_POST['url'], FILTER_VALIDATE_URL)) return wp_send_json([
            'error' => 1, 
            'message' => __('Please enter valid url'), 
            'html' => '<script>jQuery("#PUS_form").find("input[name=url]").addClass("pus_error")</script>'
        ]);

        $options = [];

        $options['url'] = filter_var($_POST['url'], FILTER_SANITIZE_URL);
        
        if($_POST['custom']){
            $options['custom'] = filter_var($_POST['custom'], FILTER_SANITIZE_STRING);
        }            
           
		$response = PUSCore::http_endpoint('post', 'url/add', $options);
        
        if($response){
            if($response->error){
                return wp_send_json([
                    'error' => 1, 
                    'message' => __($response->message)
                ]);
            }else{
                return wp_send_json([
                    'error' => 0, 
                    'message' => __('Link has been successfully shortened'),
                    'shorturl' => $response->shorturl
                ]);
            }
        }

        return wp_send_json([
            'error' => 1, 
            'message' => __('An error occurred. Please try again later')
        ]);
    }
}