<div class="wrap">
<?php if($updated): ?>
	<div id="message" class="updated below-h2"><p>Premium URL Shortener Settings Updated.</p></div>	
<?php endif ?>	
	<div id="poststuff" class="metabox-holder has-right-sidebar">
		<div style="width:48%;float:left;overflow:hidden;" class="postbox">
			<h3><?php echo esc_attr__('URL Shortener Settings', 'shortener-plugin'); ?></h3>
			<div class="inside">
				<form method="post" action="options.php" class="shortener-form">					
					<?php settings_fields('shortener_setting_group'); ?>
					<p>
						<label class="description" for="shortener_settings[shortener_url]"><?php echo esc_attr__('Enter the URL of the shortener ', 'shortener-plugin'); ?></label>
						<span class="subdescription">
							Specify the URL where the link shortener service is located. By default, the service is located at <strong>https://www.sas.com.ru/l/</strong>
						</span>									
						<input type="text" name="shortener_settings[shortener_url]" id="shortener_settings[shortener_url]" value="<?php echo self::$config['shortener_url']; ?>" />
					</p>
					<p>
						<label class="description" for="shortener_settings[shortener_api]"><?php echo esc_attr__('Enter Your API key ', 'shortener-plugin'); ?></label>
						<span class="subdescription">
							An API key is required to shorten URLs. You can get it in your <a href="https://www.sas.com.ru/l/user/settings" target="_blank" rel="noopener">personal cabinet</a>.
						</span>						
						<input type="text" name="shortener_settings[shortener_api]" id="shortener_settings[shortener_api]" value="<?php echo self::$config['shortener_api']; ?>" />
					</p>				
					<p>
						<label class="description" for="shortener_settings[shortener_post]">Post URL Shortening</label>
						<span class="subdescription">
							Enabling this will shorten all external URLs in the post section.
						</span>
						<select name="shortener_settings[shortener_post]" id="shortener_settings[shortener_post]">
							<option <?php if(self::$config["shortener_post"]) echo 'selected="selected"' ?> value="1">Enabled</option>
							<option <?php if(!self::$config["shortener_post"]) echo 'selected="selected"' ?> value="0">Disabled</option>
						</select>
					</p>
					<p>
						<label class="description" for="shortener_settings[shortener_shortcode]">Shortcode</label>
						<span class="subdescription">
							Enabling this will allow you to use shortcodes to shorten URLs within your post (Choose shortcode below).
						</span>
						<select name="shortener_settings[shortener_shortcode]" id="shortener_settings[shortener_shortcode]">							
							<option <?php if(!self::$config["shortener_shortcode"]) echo 'selected="selected"' ?> value="0">Disabled</option>
							<option <?php if(self::$config["shortener_shortcode"]=="shorten") echo 'selected="selected"' ?> value="shorten">[shorten]</option>
							<option <?php if(self::$config["shortener_shortcode"]=="shorten_url") echo 'selected="selected"' ?> value="shorten_url">[shorten_url]</option>
							<option <?php if(self::$config["shortener_shortcode"]=="srt") echo 'selected="selected"' ?> value="srt">[srt]</option>
						</select>
					</p>																		
					<p class="submit">
						<input class="button-primary" type="submit" name="Save" value="<?php echo esc_attr__('Save Changes', 'shortener-plugin'); ?>" />
					</p>
				</form>
			</div>
		</div>
		<div style="width:49.5%;float:left;overflow:hidden;margin-left:2%;" class="postbox right">
			<h3>Documentation <small style="float:right">Version: <?php echo WPPUS_VERSION ?></small></h3>
			<div class="inside docs">
				<h3 id="conf">1.0 Configuration</h3>
				<p>
					Specify the URL where the link shortener service is located. By default, the service is located at <strong>https://www.sas.com.ru/l/</strong>. If you have a personal domain, you should insert a link to the page with the service or domain name in this field. Please note that our service is free of charge. However, to connect your domain you need to <a href="https://www.sas.com.ru/wp/obratnaja-svjaz/" target="_blank" rel="noopener">contact our support team</a>. Your API key can be found in the User Dashboard.
				</p>
				<h3 id="sc">2.0 Shortcodes</h3>
				<p>
					You can use some shortcodes to either shorten a URL or to show the Ajax form in your page or post. To shorten a URL within your post or page, you can use the shortcode as defined in the options on the left side. 
				</p>
					<h4>2.1 Shortcode Example</h4>
				<p>
					The shortcode has only 1 attribute and that is to show the html link (link=true).
					<code>[shorten]https://www.sas.com.ru/l/[/shorten]</code> will ouput <code><?php if(self::$config["shortener_url"]) echo self::$config["shortener_url"]?>SAS link shortener</code>.
				</p>
				<p>
					<code>[shorten link=true]https://www.sas.com.ru/l/[/shorten]</code> will output 
					<p>&lt;a href="<?php if(self::$config["shortener_url"]) echo self::$config["shortener_url"]?>SAS link shortener" target="_blank"&gt;<?php if(self::$config["shortener_url"]) echo self::$config["shortener_url"]?>SAS link shortener&lt;/a&gt;</p>
				</p>
				<h4>2.2 Ajax Form in post or page</h4>
				<p>To show the Ajax form in your post or page, you can use the shortcode <code>[show_shortener_form]</code>. This shortcode doesn't have any attributes. The style can be changed via the options on left side.</p>
				
				<h4>2.3 Shorten Permalink using shortcode</h4>
				<p>To shorten the permalink of the post using the shortcode, you can simply add [shorten_permalink] within your post.</p>
				<h3 id="wd">3.0 Widget</h3>
				<p>You can use the widget by activating it in widget settings.</p>

				<h3 id="support">4.0 Questions and Support</h3>
				<p>If you have any questions, <a href="https://www.sas.com.ru/wp/obratnaja-svjaz/" target="_blank" rel="noopener">you can contact us here</a>.</p>
			</div>
		</div>					
	</div>
</div>