<?php
/**
 * =======================================================================================
 *                           (c) SAS tools
 * ---------------------------------------------------------------------------------------
 *  This software is packaged with an exclusive framework as such distribution
 *  or modification of this framework is not allowed before prior consent from
 *  SAS tools. If you find that this framework is packaged in a software not distributed
 *  by SAS tools or authorized parties, you must not use this software and contact gempixel
 *  at https://www.sas.com.ru/wp/obratnaja-svjaz/ to inform them of this misuse.
 * =======================================================================================
 *
 * @package SAS tools\URL-Shortener-WP
 * @author SAS tools (https://www.sas.com.ru/)
 * @link https://www.sas.com.ru/
 */

class PUSCore
{
	/**
	 * @var Debug
	 **/
	protected static $debug = 0;
	/**
	 * @var Configuration
	 **/
	protected static $config = [];
	/**
	 * @var API Key
	 **/
	protected static $key = NULL;
	/**
	 * @var Shortener URL
	 **/
	protected static $url = NULL;
	/**
	 * Set variables
	 * @since 3.0
	 **/
	public static function start($config){
		// Default Values
		if(!$config || empty($config) || !is_array($config)){
			$config = [
				"shortener_url" => "",
				"shortener_api" => "",
				"shortener_post" => "0",
				"shortener_comment" => "0",
				"shortener_shortcode_type" => "php",
				"shortener_shortcode" => "0",
				"shortener_theme" => ""
			];
		}
		if(!isset($config["shortener_post"])) $config["shortener_post"] = "0";

		self::$config = $config;
		PUS_Widget::$config = $config;
		self::$key = self::$config["shortener_api"];
		self::$url = trim(self::$config["shortener_url"], '/');

		if(self::$config["shortener_shortcode"] && in_array(self::$config["shortener_shortcode"], ["shorten","shorten_url","srt"])){
			add_shortcode(self::$config["shortener_shortcode"], ['PUSCore','shortcode']);
		}

		add_shortcode("shorten_permalink", array('PUSCore','shortcode_permalink'));

		add_shortcode("show_shortener_form", ['PUS_Widget','post_form']);

		add_action('admin_head', ["PUSCore", "multiuser"]);

		add_action('wp_footer', ["PUSCore", "auto_js"]);

		add_action('publish_post', ["PUSCore", "save_post"], 10, 3 );


		add_filter( 'manage_post_posts_columns', 'set_post_shorturl_columns' );
		function set_post_shorturl_columns($columns) {
			$columns['shorturl'] = __( 'Short URL', 'shorturl' );

			return $columns;
		}

		add_filter( 'manage_pages_columns', 'set_custom_edit_shorturl_columns' );
		function set_custom_edit_shorturl_columns($columns) {
			$columns['shorturl'] = __( 'Short URL', 'shorturl' );

			return $columns;
		}
		add_action( 'manage_post_posts_custom_column' , 'custom_shorturl_column', 10, 2 );
		add_action( 'manage_pages_custom_column' , 'custom_shorturl_column', 10, 2 );
		function custom_shorturl_column( $column, $postid ) {
			$shorturl = '';

			if('publish' !== get_post_status( $id )) return print('Publish to generate a short link');

			if($column == 'shorturl'){
				
				$shorturl_meta = get_post_meta($postid, 'pus_shorturl');

				if(!$shorturl_meta || empty($shorturl_meta)){
					
					PUSCore::checkUser();
        
					$key = PUSCore::getAPI();
			
					$options = [];
			
					$options['url'] = filter_var(get_permalink($postid), FILTER_SANITIZE_URL);				
							 
					$response = PUSCore::http_endpoint_api($key, 'post', 'url/add', $options);
					
					if($response && isset($response->error) && !$response->error && isset($response->shorturl)){
						update_post_meta($postid, 'pus_shorturl', $response->shorturl);
						$shorturl = '<a target="_blank" href="'.$response->shorturl.'">'.$response->shorturl.'</a>';
						$shorturl .='<p><a href="https://www.facebook.com/sharer/sharer.php?u='.$response->shorturl.'"
										target="_blank" rel="noopener noreferrer" title="Share on Facebook"><svg aria-hidden="true" role="img" focusable="false" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" class="dashicon dashicons-facebook-alt"><path d="M8.46 18h2.93v-7.3h2.45l.37-2.84h-2.82V6.04c0-.82.23-1.38 1.41-1.38h1.51V2.11c-.26-.03-1.15-.11-2.19-.11-2.18 0-3.66 1.33-3.66 3.76v2.1H6v2.84h2.46V18z"></path></svg></a>
										<a href="https://twitter.com/share?url='.$response->shorturl.'&text='.get_the_title($post_id).'"
										target="_blank" rel="noopener noreferrer" title="Share on Twitter"><svg aria-hidden="true" role="img" focusable="false" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" class="dashicon dashicons-twitter"><path d="M18.94 4.46c-.49.73-1.11 1.38-1.83 1.9.01.15.01.31.01.47 0 4.85-3.69 10.44-10.43 10.44-2.07 0-4-.61-5.63-1.65.29.03.58.05.88.05 1.72 0 3.3-.59 4.55-1.57-1.6-.03-2.95-1.09-3.42-2.55.22.04.45.07.69.07.33 0 .66-.05.96-.13-1.67-.34-2.94-1.82-2.94-3.6v-.04c.5.27 1.06.44 1.66.46-.98-.66-1.63-1.78-1.63-3.06 0-.67.18-1.3.5-1.84 1.81 2.22 4.51 3.68 7.56 3.83-.06-.27-.1-.55-.1-.84 0-2.02 1.65-3.66 3.67-3.66 1.06 0 2.01.44 2.68 1.16.83-.17 1.62-.47 2.33-.89-.28.85-.86 1.57-1.62 2.02.75-.08 1.45-.28 2.11-.57z"></path></svg></a></p>';
					}
				}else {
					$shorturl = '<a target="_blank" href="'.$shorturl_meta[0].'">'.$shorturl_meta[0].'</a>';
					$shorturl .='<p><a href="https://www.facebook.com/sharer/sharer.php?u='.$shorturl_meta[0].'"
					target="_blank" rel="noopener noreferrer" title="Share on Facebook"><svg aria-hidden="true" role="img" focusable="false" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" class="dashicon dashicons-facebook-alt"><path d="M8.46 18h2.93v-7.3h2.45l.37-2.84h-2.82V6.04c0-.82.23-1.38 1.41-1.38h1.51V2.11c-.26-.03-1.15-.11-2.19-.11-2.18 0-3.66 1.33-3.66 3.76v2.1H6v2.84h2.46V18z"></path></svg></a>
					<a href="https://twitter.com/share?url='.$shorturl_meta[0].'&text='.get_the_title($post_id).'"
					target="_blank" rel="noopener noreferrer" title="Share on Twitter"><svg aria-hidden="true" role="img" focusable="false" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" class="dashicon dashicons-twitter"><path d="M18.94 4.46c-.49.73-1.11 1.38-1.83 1.9.01.15.01.31.01.47 0 4.85-3.69 10.44-10.43 10.44-2.07 0-4-.61-5.63-1.65.29.03.58.05.88.05 1.72 0 3.3-.59 4.55-1.57-1.6-.03-2.95-1.09-3.42-2.55.22.04.45.07.69.07.33 0 .66-.05.96-.13-1.67-.34-2.94-1.82-2.94-3.6v-.04c.5.27 1.06.44 1.66.46-.98-.66-1.63-1.78-1.63-3.06 0-.67.18-1.3.5-1.84 1.81 2.22 4.51 3.68 7.56 3.83-.06-.27-.1-.55-.1-.84 0-2.02 1.65-3.66 3.67-3.66 1.06 0 2.01.44 2.68 1.16.83-.17 1.62-.47 2.33-.89-.28.85-.86 1.57-1.62 2.02.75-.08 1.45-.28 2.11-.57z"></path></svg></a></p>';
				}
			}

			echo $shorturl;
		}
	}
	/**
	 * CSS
	 *
	 * @author SAS link shortener <https://www.sas.com.ru/>
	 * @version 1.0
	 * @return void
	 */
	public static function front(){
		wp_enqueue_style('shortener-styles-stylesheet', plugins_url('assets/themes.css', dirname(__FILE__) ));
		wp_enqueue_script('shortener-js', plugins_url('urlshortener.js', dirname(__FILE__) ), ['jquery']);
	}

	/**
	 * Admin CSS Files
	 * @since 3.0
	 **/
	public static function admin_css(){
		wp_enqueue_style('shortener-admin-stylesheet', plugins_url('assets/admin-style.css', dirname(__FILE__) ));
		wp_enqueue_style('shortener-admin-styles-stylesheet', plugins_url('assets/themes.css', dirname(__FILE__) ));
	}
	/**
	 * Admin JS Files
	 * @since 3.0
	 **/
	public static function admin_js(){
		wp_enqueue_script('shortener-admin-js', plugins_url('assets/admin.js', dirname(__FILE__) ), ['jquery']);
	}
	/**
	 * Auto JS
	 *
	 * @author SAS link shortener <https://www.sas.com.ru/>
	 * @version 3.0
	 * @return void
	 */
	public static function auto_js(){

		if(!self::$config["shortener_post"]) return false;

		echo '<script type="text/javascript">
				var key = "'.md5(self::$config["shortener_api"]).'";
				var selector = ".entry-content p a,.page p a";
			</script>
			<script type="text/javascript" src="'.self::$config["shortener_url"].'script.js"></script>';
	}
	/**
	 * Register Widget
	 *
	 * @author SAS link shortener <https://www.sas.com.ru/>
	 * @version 3.0
	 * @return void
	 */
	public static function register_widget(){
		register_widget('PUS_Widget');
	}
	/**
	 * Check if user registered or not
	 *
	 * @author SAS link shortener <https://www.sas.com.ru/>
	 * @version 1.0
	 * @return void
	 */
	public static function checkUser(){

		$user = get_userdata(get_current_user_id());

		$usermeta = get_user_meta(get_current_user_id());

		if(!is_user_logged_in()) return false;

		if(!isset($usermeta['pus_userid'])){

			$response = self::http_endpoint('get', 'users', ['email' => $user->data->user_email]);

			if(isset($response->data[0]) && isset($response->data[0]->apikey) && $response->data[0]->apikey && $response->data[0]->email == $user->data->user_email){

				add_user_meta(get_current_user_id(), 'pus_userid', $response->data[0]->id);

			}else{

				$response = self::http_endpoint('post', 'user/add', [
					'email' => $user->data->user_email,
					'username' => $user->data->user_login.'_'.wp_rand(),
					'password' => md5(wp_rand().wp_rand())
				]);

				if(isset($response->id)){
					add_user_meta(get_current_user_id(), 'pus_userid', $response->id);
				}
			}
		}
	}
	/**
	 * Get API
	 *
	 * @author SAS link shortener <https://www.sas.com.ru/>
	 * @version 1.0
	 * @return void
	 */
	public static function getAPI(){

		$usermeta = get_user_meta(get_current_user_id());

		$response = self::http_endpoint('get', 'user/'.$usermeta['pus_userid'][0]);

		if($response && isset($response->data) && isset($response->data->apikey)){
			return $response->data->apikey;
		}
		return null;
	}

	/**
	 * Settings
	 *
	 * @author SAS link shortener <https://www.sas.com.ru/>
	 * @version 1.0
	 * @return void
	 */
	public static function shortener_index(){

		if(!self::$config["shortener_url"] || !self::$config["shortener_api"]){
			return print('<div class="error-message error inline error-warning notice-alt"><p>Please configure plugin in the Settings. <a class="button-link" href="'.menu_page_url('wppus_settings', false).'">Configure now</a></p></div>');
		}

		self::checkUser();

		$usermeta = get_user_meta(get_current_user_id());

		$response = self::http_endpoint('get', 'user/login/'.$usermeta["pus_userid"][0], []);
		$sso = '#';

		if($response && isset($response->url)) $sso = $response->url;

		include(PUSDIR."/template/index.php");
	}

	/**
	 * SSO user
	 *
	 * @author SAS link shortener <https://www.sas.com.ru/>
	 * @version 1.0
	 * @return void
	 */
	public static function sso(){

		if(!self::$config["shortener_url"] || !self::$config["shortener_api"]) {
			return print('<div class="error-message error inline error-warning notice-alt"><p>Please configure plugin in the Settings. <a class="button-link" href="'.menu_page_url('wppus_settings', false).'">Configure now</a></p></div>');
		}

		$usermeta = get_user_meta(get_current_user_id());

		$response = self::http_endpoint('get', 'user/login/'.$usermeta["pus_userid"][0], []);
		$sso = '#';

		if($response && isset($response->url)) $sso = $response->url;
		include(PUSDIR."/template/sso.php");
	}
	/**
	 * Send HTTP Request
	 * @since v1.0
	 **/
	protected static function http_request($method, $url, $body = []){

		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => $url,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 2,
			CURLOPT_TIMEOUT => 10,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_CUSTOMREQUEST => strtoupper($method),
			CURLOPT_HTTPHEADER => [
				"Authorization: Bearer ".self::$key,
				"Content-Type: application/json",
			],
			CURLOPT_POSTFIELDS => json_encode($body),
		));

		$response = curl_exec($curl);
		curl_close($curl);
		return $response;
	}

	/**
	 * [http_endpoint description]
	 * @author SAS link shortener <https://www.sas.com.ru/>
	 * @version 1.0
	 * @param   [type] $endpoint [description]
	 * @param   [type] $body     [description]
	 * @return  [type]           [description]
	 */
	public static function http_endpoint($method, $endpoint, $body = [], $array = false){

		$curl = curl_init();

		if($method == 'get') $endpoint .= '?'.http_build_query($body);

		curl_setopt_array($curl, array(
			CURLOPT_URL => self::$url."/api/".$endpoint,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 2,
			CURLOPT_TIMEOUT => 10,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_CUSTOMREQUEST => strtoupper($method),
			CURLOPT_HTTPHEADER => [
				"Authorization: Bearer ".self::$key,
				"Content-Type: application/json",
				],
			CURLOPT_POSTFIELDS => json_encode($body),
		));

		$response = curl_exec($curl);

		curl_close($curl);
		return $array ? json_decode($response, true) : json_decode($response);
	}
	/**
	 * Request with API Key
	 *
	 * @author SAS link shortener <https://www.sas.com.ru/>
	 * @version 1.0
	 * @param [type] $method
	 * @param [type] $endpoint
	 * @param [type] $body
	 * @param boolean $array
	 * @return void
	 */
	public static function http_endpoint_api($key, $method, $endpoint, $body, $array = false){

		$curl = curl_init();

		if($method == 'get') $endpoint .= '?'.http_build_query($body);

		curl_setopt_array($curl, array(
			CURLOPT_URL => self::$url."/api/".$endpoint,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 2,
			CURLOPT_TIMEOUT => 10,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_CUSTOMREQUEST => strtoupper($method),
			CURLOPT_HTTPHEADER => [
				"Authorization: Bearer ".$key,
				"Content-Type: application/json",
				],
			CURLOPT_POSTFIELDS => json_encode($body),
		));

		$response = curl_exec($curl);

		curl_close($curl);
		return $array ? json_decode($response, true) : json_decode($response);
	}
	/**
	 * Admin Functions
	 * @since 1.0
	 **/
	public static function admin_menu() {
		add_menu_page('Premium URL Shortener Plugin', 'URL Shortener', 'read', 'wppus', ["PUSCore","shortener_index"]);
		add_submenu_page('wppus', 'Login to Platform', 'Login to Platform', 'read', 'wppus_sso', ['PUSCore', 'sso']);
		add_submenu_page('wppus', 'My Links', 'Links', 'read', 'wppus_links', ['\GemPixel\PUSLinks', 'factory']);
		add_submenu_page('wppus', 'My QR Codes', 'QR Codes', 'read', 'wppus_qrs', ['\GemPixel\PUSQrs', 'factory']);
		add_submenu_page('wppus', 'Settings', 'Settings', 'manage_options', 'wppus_settings', ['PUSCore', 'shortener_options']);
	}
	/**
	 * Admin Int Settings
	 * @since 1.0
	 **/
	public static function admin_setting() {
		register_setting('shortener_setting_group','shortener_settings');
	}

	/**
	 * Admin Settings Page
	 * @since 1.0
	 **/
	public static function shortener_options() {

		if (!current_user_can( 'manage_options'))  {
			wp_die(__( 'You do not have sufficient permissions to access this page.','shortener-plugin'));
		}

		$updated = false;

		if(isset($_GET["settings-updated"]) && $_GET["settings-updated"] == true) $updated = true;
		include(PUSDIR."/template/settings.php");
	}
	/**
	 * Uninstall Plugin and Clean Database
	 * @since 1.0
	 **/
	public static function uninstall(){
		// delete options
		delete_option('shortener_settings');
		delete_option('widget_shortener_widget');
	}
	/**
	 * Install Plugin
	 * @since 1.0
	 **/
	public static function install(){
		// delete options
		$value = [
				"shortener_url"=>"",
				"shortener_api"=>"",
				"shortener_comment"=>"0",
				"shortener_shortcode_type"=>"php",
				"shortener_shortcode"=>"0",
				"shortener_theme"=>""
		];
		add_option("shortener_settings", serialize($value),"","yes");
	}
	/**
	 * Add meta box to post/page
	 * @since 1.0
	 **/
	public static function add_to_post( $post_type, $post ) {
			add_meta_box(
				'quick_url_shorten_admin',
				__( 'Quick URL Shortener', 'shortener-plugin'),
				array("PUSCore","render_box"),
				'post',
				'normal',
				'default'
			);

			add_meta_box(
				'quick_url_shorten_admin',
				__( 'Quick URL Shortener', 'shortener-plugin'),
				array("PUSCore","render_box"),
				'page',
				'normal',
				'default'
			);

			add_meta_box(
				'quick_url_shorten_admin',
				__( 'Quick URL Shortener', 'shortener-plugin'),
				array("PUSCore","render_box"),
				'custom-type',
				'normal',
				'default'
			);

			add_meta_box(
				'quick_url_shorten_auto_url',
				__( 'Short URL', 'shortener-plugin'),
				array("PUSCore","short_box"),
				'post',
				'side',
				'high'
	    	);
	}
	/**
	 * Rendered Box
	 * @since 1.0
	 **/
	public static function render_box(){
		echo '<div data-action="'.admin_url('admin-ajax.php' ).'" data-loader="'. plugins_url('assets/loader.svg', dirname(__FILE__) ).'" id="PUS_form">
			<div id="quick_url_shorten_admin_form">
				<div id="quick_url_shorten_admin_message"></div>
				<label for="quick_url_shorten_admin_input">Long URL</label>
				<p>
					<input type="text" style="width:100%;padding:10px; margin-bottom: 5px;" id="quick_url_shorten_admin_input" name="url" autocomplete="off" value="" placeholder="Enter your short link">
				</p>
				<div style="border-radius:5px;border:1px solid #ccc;padding: 8px;">
					<div class="row">
						<div>
							<div class="form-group">
								<p><label for="custom">'.__('Custom Alias').'</label></p>
								<div class="input-group">
									<div class="input-group-text bg-white"</div>
									<input type="text" class="form-control border-start-0 ps-0 p-2" name="custom" id="custom" placeholder="'.__("Type your custom alias here").'" autocomplete="off">
								</div>
							</div>
						</div>
						<div>
							<p><label for="quick_url_shorten_admin_password">Password:</label></p>
							<p><input type="text" id="quick_url_shorten_admin_password" name="password" autocomplete="off" value=""></p>
						</div>
					</div>
					<div class="flex-container">
						<div>
							<p><label for="quick_url_shorten_admin_domains">Domain</label></p>
							<p>
								<select id="quick_url_shorten_admin_domains" name="domain">';
									foreach(self::domains() as $domain){
										echo '<option value="'.$domain.'">'.$domain.'</option>';
									}
							echo '</select>
							</p>
						</div>
						<div>
							<p><label for="quick_url_shorten_admin_expiration">Expiration</label></p>
							<p>
								<input type="date" name="expiration">
							</p>
						</div>
					</div>
				</div>
				<p><button type="button" id="quick_url_shorten_admin_button" class="gemui-btn-primary">Shorten</button></p>
			</div>
		</div>';
	}
	/**
	 * Get Domains
	 *
	 * @author SAS link shortener <https://www.sas.com.ru/>
	 * @version 1.0
	 * @return void
	 */
	public static function domains(){

		$key = PUSCore::getAPI();

		$domains = self::http_endpoint_api($key, "get", "domains", ["limit" => 1000, "order" => "date"]);

		$list[] = trim(self::$url, '/');

		foreach($domains->data->domains as $domain){
			$list[] = $domain->domain;
		}

		return $list;
	}
	/**
	 * [add_to_dashboard description]
	 * @author SAS link shortener <https://www.sas.com.ru/>
	 * @version 1.0
	 */
	public static function add_to_dashboard(){
			global $wp_meta_boxes;

			wp_add_dashboard_widget('pus_latest_url', 'Latest Short Links', ["PUSCore", "render_latest_links"]);
			wp_add_dashboard_widget('pus_latest_qrs', 'Latest QR Codes', ["PUSCore", "render_latest_qrs"]);
			wp_add_dashboard_widget('pus_top_url', 'Top Short Links', ["PUSCore", "render_top_links"]);
	}
	/**
	 * [render_links description]
	 * @author SAS link shortener <https://www.sas.com.ru/>
	 * @version 1.0
	 * @return  [type] [description]
	 */
	public static function render_latest_links(){

		if(!self::$config["shortener_url"] || !self::$config["shortener_api"]) {
			return print('<div class="error-message error inline error-warning notice-alt"><p>Please configure plugin in the Settings. <a class="button-link" href="'.menu_page_url('wppus_settings', false).'">Configure now</a></p></div>');
		}

		PUSCore::checkUser();

		$key = PUSCore::getAPI();

		$links = self::http_endpoint_api($key, "get", "urls", ["limit" => 5, "order" => "date"]);

		if(!$links || $links->error) return print("An error occurred. Please check API key or site URL");

		echo '<ul class="activity-block last" aria-hidden="false">';

		foreach ($links->data->urls as $url) {
			echo '
			<li>
				<div class="url-info">
					<div class="event-icon dashicons dashicons-admin-links" aria-hidden="true"></div>
					<div class="event-info-inner">
						<a class="url-title" href="'.$url->longurl.'" target="_blank">'.(!empty($url->title) ? self::truncate($url->title, 50) : $url->shorturl).'</a> <small>('.$url->clicks.' clicks)</small>
					</div>
				</div>

				<div class="short-url">
					<a href="'.$url->shorturl.'"><span>'.$url->shorturl.'</span></a> &nbsp;&nbsp;&bullet;&nbsp;&nbsp; '.date("F d Y H:i", strtotime($url->date)).'
				</div>
				<hr>
			</li>';
		}
		echo '</ul>';
	}
	/**
	 * QR Codes
	 *
	 * @author SAS link shortener <https://www.sas.com.ru/>
	 * @version 1.0
	 * @return void
	 */
	public static function render_latest_qrs(){

		if(!self::$config["shortener_url"] || !self::$config["shortener_api"]) {
			return print('<div class="error-message error inline error-warning notice-alt"><p>Please configure plugin in the Settings. <a class="button-link" href="'.menu_page_url('wppus_settings', false).'">Configure now</a></p></div>');
		}

		$qrs = self::http_endpoint("get", "qr", ["limit" => 5, "order" => "date"]);

		if(!$qrs || $qrs->error) return print("An error occurred. Please check API key or site URL");

		if(!$qrs->data->qrs) return print("No QR code generated.");

		echo '<ul class="activity-block last" aria-hidden="false">';

		foreach ($qrs->data->qrs as $qr) {
			echo '
			<li>
				<div class="qr-info">
					<div class="event-icon dashicons dashicons-admin-links" aria-hidden="true"></div>
					<div class="event-info-inner">
						<a class="qr-title" href="'.$qr->link.'" target="_blank">'.(!empty($qr->title) ? self::truncate($qr->title, 50) : $qr->link).'</a> <small>('.$qr->scans.' scans)</small>
					</div>
				</div>

				<div class="short-qr">
					<a href="'.$qr->link.'"><span>'.$qr->link.'</span></a> &nbsp;&nbsp;&bullet;&nbsp;&nbsp; '.date("F d Y H:i", strtotime($qr->date)).'
				</div>
				<hr>
			</li>';
		}
		echo '</ul>';
	}
	/**
	 * [render_top_links description]
	 * @author SAS link shortener <https://www.sas.com.ru/>
	 * @version 1.0
	 * @return  [type] [description]
	 */
	public static function render_top_links(){

		if(!self::$config["shortener_url"] || !self::$config["shortener_api"]) {
			return print('<div class="error-message error inline error-warning notice-alt"><p>Please configure plugin in the Settings. <a class="button-link" href="'.menu_page_url('wppus_settings', false).'">Configure now</a></p></div>');
		}

		PUSCore::checkUser();

		$key = PUSCore::getAPI();

		$links = self::http_endpoint_api($key, "get", "urls", ["limit" => 5, "order" => "click"]);

		if(!$links || $links->error) return print("An error occurred. Please check API key or site URL");

		echo '<ul class="activity-block last" aria-hidden="false">';

		foreach ($links->data->urls as $url) {
			echo '
			<li>
				<div class="url-info">
					<div class="event-icon dashicons dashicons-admin-links" aria-hidden="true"></div>
					<div class="event-info-inner">
						<a class="url-title" href="'.$url->longurl.'" target="_blank">'.(!empty($url->title) ? self::truncate($url->title, 50) : $url->shorturl).'</a> <small>('.$url->clicks.' clicks)</small>
					</div>
				</div>

				<div class="short-url">
					<a href="'.$url->shorturl.'"><span>'.$url->shorturl.'</span></a> &nbsp;&nbsp;&bullet;&nbsp;&nbsp; '.date("F d Y H:i", strtotime($url->date)).'
				</div>
				<hr>
			</li>';
		}
		echo '</ul>';
	}

	/**
	 * [multiuser description]
	 * @author SAS link shortener <https://www.sas.com.ru/>
	 * @version 1.0
	 * @return  [type] [description]
	 */
	public static function multiuser(){

		if(current_user_can('editor') || current_user_can('subscriber') || current_user_can('contributor') || current_user_can('author')){
			// Add custom meta box
			add_action( 'add_meta_boxes', array('PUSCore','add_to_post'), 10, 2 );
		}

	}
	/**
	 * [save_post description]
	 * @author SAS link shortener <https://www.sas.com.ru/>
	 * @version 1.0
	 * @return  [type] [description]
	 */
	public static function save_post($post_id){
		global $post;

		if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return '';

    	if (!current_user_can('edit_post')) return '';

		$url = explode("?", $post->guid);

		PUSCore::checkUser();

		$key = PUSCore::getAPI();

		$short = self::http_endpoint_api($key, 'post', "url/add", [
			"url" => $url[0].$post->post_name
		]);

		echo $short->short;

	}
	/**
	 * [short_box description]
	 * @author SAS link shortener <https://www.sas.com.ru/>
	 * @version 1.0
	 * @return  [type] [description]
	 */
	public static function short_box(){
		global $post;

		if($post->post_status != "publish") return;

		echo '<div id="PUS_Short_URL">';

		if(isset($post->guid)){

			PUSCore::checkUser();

			$key = PUSCore::getAPI();

			$response = self::http_endpoint_api($key, 'post', "url/add", [
				"url" => $post->guid
			]);

			echo "<p><h5>Short Link</h5><i class=\"dashicons dashicons-admin-links\"></i> <a href=\"{$response->shorturl}\" target=\"_blank\">{$response->shorturl}</a></p>";
			echo "<p><h5>QR Link</h5><i class=\"dashicons dashicons-smartphone\"></i> <a href=\"{$response->shorturl}/qr\" target=\"_blank\">{$response->shorturl}/qr</a></p>";
		}

		echo "</div>";
	}
	/**
	 * Shortcode
	 *
	 * @author SAS link shortener <https://www.sas.com.ru/>
	 * @version 1.0
	 * @param [type] $atts
	 * @param [type] $content
	 * @return void
	 */
	public static function shortcode($atts, $content){

		$link = (isset($atts["link"]) && $atts["link"]) ? true : false;

		PUSCore::checkUser();

		$key = PUSCore::getAPI();

        $options = [];

        $options['url'] = filter_var($content, FILTER_SANITIZE_URL);

		if(isset($atts['domain']) && empty($atts['domain'])){
			$options['domain'] = filter_var($atts['domain'], FILTER_SANITIZE_STRING);
		}

		$response = PUSCore::http_endpoint_api($key, 'post', 'url/add', $options);

		if($response && $response->error == 0){
			if($link){
				return '<a href="'.$response->shorturl.'" target="_blank">'.$response->shorturl.'</a>';
			}else{
				return $response->shorturl;
			}
        }

		return $content;
	}
	/**
	 * [truncate description]
	 * @author SAS link shortener <https://www.sas.com.ru/>
	 * @version 1.0
	 * @param   [type] $string [description]
	 * @param   [type] $del    [description]
	 * @param   string $limit  [description]
	 * @return  [type]         [description]
	 */
	public static function truncate($string,$del,$limit="...") {
    	$len = strlen($string);
		if ($len > $del) {
			$new = substr($string,0,$del).$limit;
			return $new;
		}
      	return $string;
	}
}