<?php
/**
 * =======================================================================================
* (c) SAS tools
* ---------------------------------------------------------------------------------------
* This software is packaged with an exclusive framework as such distribution
* or modification of this framework is not allowed before prior consent from
* SAS tools. If you find that this framework is packaged in a software not distributed
* by SAS tools or authorized parties, you must not use this software and contact gempixel
* at https://www.sas.com.ru/wp/obratnaja-svjaz/ to inform them of this misuse.
* =======================================================================================
*
* @package SAS tools\URL-Shortener-WP
* @author SAS tools (https://www.sas.com.ru/)
* @link https://www.sas.com.ru/
 */

namespace GemPixel;

use WP_List_Table;
use PUSCore;

class PUSQrs extends WP_List_Table
{
    /**
     * Results Count
     *
     * @author SAS tools <https://www.sas.com.ru> 
     * @version 1.0
     */
    private $count = null;
    /**
     * Construct
     *
     * @author SAS tools <https://www.sas.com.ru> 
     * @version 1.0
     */
    public function __construct() {

        parent::__construct( [
            'singular' => 'Lnk',
            'plural' => 'Links',
            'ajax' => true
        ]);

    }
    /**
     * factory
     *
     * @author SAS tools <https://www.sas.com.ru> 
     * @version 1.0
     * @param integer $per_page
     * @param integer $page_number
     * @return void
     */
    public static function factory($per_page = 5, $page_number = 1) {
        $qrs = new self();
        include(PUSDIR.'/template/qrs.php');
    }

    
    /**
     * Get Links
     *
     * @author SAS tools <https://www.sas.com.ru> 
     * @version 1.0
     * @param integer $per_page
     * @param integer $page_number
     * @return void
     */
	public function get_data($limit = 10, $page = 1) {

        PUSCore::checkUser();
        
        $key = PUSCore::getAPI();

		$response = PUSCore::http_endpoint_api($key, 'get', 'qr', ['limit' => $limit, 'page' => $page], true);
        
        if($response && !$response['error']){
            $this->count = $response['data']['result'];
            return $response['data']['qrs'];
        }
		return [];
	}


	/**
     * Delete Link
     *
     * @author SAS tools <https://www.sas.com.ru> 
     * @version 1.0
     * @param [type] $id
     * @return void
     */
	public function delete($id) {		
        PUSCore::http_endpoint('delete', 'qr/'.$id.'/delete', []);
	}


	/**
	 * Returns the count  of qrs
	 *
	 */
	public function count() {
		return $this->count;
	}

    /**
     * No items
     *
     * @author SAS tools <https://www.sas.com.ru> 
     * @version 1.0
     * @return void
     */
	public function no_items() {
		return print('No qrs available.');
	}


	/**
	 * Render a column when no column specific method exist.
	 *
	 * @param array $item
	 * @param string $column_name
	 *
	 * @return mixed
	 */
	public function column_default( $item, $column_name ) {             
		switch ($column_name) {
			case 'id':
                $delete_nonce = wp_create_nonce( 'wppus_delete_link' );

                $actions = [
                    'delete' => sprintf( '<a href="?page=%s&action=%s&qr=%s&_wpnonce=%s">Delete</a>', esc_attr( $_REQUEST['page'] ), 'delete', absint( $item['id'] ), $delete_nonce )
                ];
                return $item[$column_name].$this->row_actions( $actions );
            case 'qr':
                return '<a href="'.$item['link'].'" target="_blank"><img src="'.$item['link'].'" width="100"></a>';
			case 'name':
			case 'scans':
			case 'date':  
                return $item[$column_name];
            case 'link':   
                return '<a href="'.$item[$column_name].'" target="_blank">'.$item[$column_name].'</a>';
			default:
				return print_r( $item, true );
		}
	}

	/**
	 * Render the bulk edit checkbox
	 *
	 * @param array $item
	 *
	 * @return string
	 */
	public function column_cb( $item ) {
        
		return sprintf(
			'<input type="checkbox" name="bulk-delete[]" value="%s" />', $item['id']
		);
	}
	/**
	 *  Associative array of columns
	 *
	 * @return array
	 */
	function get_columns() {
		$columns = [
			'cb'      => '<input type="checkbox" />',
            'id' => 'ID',
            'qr' => 'QR',
			'name'   => 'Name',
			'link' => 'Link',
			'scans'    => 'Scans',
		];

		return $columns;
	}   

	/**
	 * Returns an associative array containing the bulk action
	 *
	 * @return array
	 */
	public function get_bulk_actions() {
		$actions = [
			'bulk-delete' => 'Delete'
		];

		return $actions;
	}


	/**
     * Prepare Tables
     *
     * @author SAS tools <https://www.sas.com.ru> 
     * @version 1.0
     * @return void
     */
	public function prepare_items() {

		$this->_column_headers = [$this->get_columns()];

        $per_page     = $this->get_items_per_page('qrs_per_page', 15);
		$current_page = $this->get_pagenum();

        $this->delete_all();

        $items = $this->get_data($per_page, $current_page);

        $total_items  = $this->count();

		$this->set_pagination_args([
			'total_items' => $total_items,
			'per_page'    => $per_page
		]);
        
        $this->items = $items;
	}
    /**
     * Delete
     *
     * @author SAS tools <https://www.sas.com.ru> 
     * @version 1.0
     * @return void
     */
    public function delete_all(){
    
        if ( 'delete' === $this->current_action() ) {
            
            $nonce = esc_attr( $_REQUEST['_wpnonce'] );
            
            if (!wp_verify_nonce( $nonce, 'wppus_delete_link')) {                
                wp_redirect( esc_url( admin_url('admin.php?page=wppus_qrs&success=false') ));
                
            }else {                
                //$this->delete( absint( $_GET['link'] ) );        
                wp_redirect( esc_url( admin_url('admin.php?page=wppus_qrs&success=true') ));
                
            }
        }     
        
        
        if((isset( $_POST['action'] ) && $_POST['action'] == 'bulk-delete' ) || ( isset( $_POST['action2'] ) && $_POST['action2'] == 'bulk-delete' ) ) {

            $delete_ids = esc_sql( $_POST['bulk-delete'] );

            foreach ( $delete_ids as $id ) {
                $this->delete(absint($id));
            }

            wp_redirect( esc_url( admin_url('admin.php?page=wppus_qrs&success=true') ) );
            exit;
        }
    }


}