<?php

/*
Plugin Name: URL Shortener WP plugin
Plugin URI: https://www.sas.com.ru/wp/cokrashhenie-otslezhivanie-i-upravlenie-url/
Description: Creates a frontend for your website to shorten URLs via your URL Shortener!
Version: 4.0
Author: SAS link shortener
Author URI: https://www.sas.com.ru/
*/

define('WPPUS_VERSION', '4.0');
define('PUSDIR', dirname(__FILE__));

if (!class_exists('WP_List_Table')) {
	require_once(ABSPATH . 'wp-admin/includes/class-wp-list-table.php');
}

include(PUSDIR."/core/PUSCore.php");
include(PUSDIR."/core/Widget.class.php");

include(PUSDIR."/core/PUSLinks.php");
include(PUSDIR."/core/PUSQrs.php");

if(is_admin()) {
	// Add to admin menu
	add_action('admin_menu', ['PUSCore','admin_menu']);
	// Register Settings
	add_action('admin_init', ['PUSCore','admin_setting']);
	// Add Admin CSS and JS
	add_action('admin_enqueue_scripts', ['PUSCore','admin_css']);
	add_action('admin_enqueue_scripts', ['PUSCore','admin_js']);

	// Add custom meta box
	add_action( 'add_meta_boxes', ['PUSCore','add_to_post'], 10, 2);

	add_action('wp_dashboard_setup', ["PUSCore", 'add_to_dashboard']);
	
	// Logged
	add_action( 'wp_ajax_pus_shorten', ['\GemPixel\PUSLinks', 'shorten'] );

	// Install and Uninstall actions
	register_activation_hook(__FILE__, ['PUSCore','install']);
	register_deactivation_hook(__FILE__, ['PUSCore','uninstall']);
	
}

add_action( 'wp_ajax_nopriv_pus_shorten', ['\GemPixel\PUSLinks', 'shortenPublic'] );	

// Add Widgets
add_action('widgets_init', ['PUSCore','register_widget']);

// Add Front-end CSS & JS
add_action('wp_enqueue_scripts', ['PUSCore','front']);

// Start Plugin
PUSCore::start(get_option('shortener_settings'));