/**
 * URL Shortener jQuery Plugin
 * Author URI: https://www.sas.com.ru/
 **/
jQuery(document).ready(function(){   
  "use strict";
  jQuery(document).on('click', "#quick_url_shorten_admin_button", function(e){
    
    e.preventDefault();
    
    let form = jQuery('#PUS_form');
    let text = form.find('button[type=button]').text();

    jQuery.ajax({
      url: form.data('action'),
      method: 'POST',
      data: form.find(':input').serialize()+'&action=pus_shorten',
      beforeSend: function() {
        form.find('button[type=button]').html('<img src="'+form.data('loader')+'" id="pus_loader">');
      }
    })
    .fail(function(){
      $("#PUS_form").before('<div id="pus_message" class="notice notice-error is-dismissible">An error occurred. Please try again later</div>')
    })
    .done(function(response){
     form.find('#pus_message').remove();
     form.find('input').removeClass('pus_error');

      if(typeof response.html !== undefined){
        jQuery('body').append(response.html);
      }
      
      form.find('button[type=button]').text(text);

      if(response.error){
         form.prepend('<div id="pus_message" class="notice notice-error is-dismissible">'+response.message+'</div>');            
        }else{          
          form.prepend('<div id="pus_message" class="notice notice-success is-dismissible">'+response.message+'</div>');   
          form.find('input[name=url]').val(response.shorturl);  
          form.find('input[name=url]').select();
          form.find('input[name=custom]').val('');
          form.find('input[name=password]').val('');
        }
    });     
  });
});